

RHM <- function(
    NatHSS,
    InvHSS = 0,
    alpha = 1,
    beta = 2) {
  
  # validate native
  if (missing(NatHSS)) stop("NatHSS is required.")
  if (!(is.numeric(NatHSS) && length(NatHSS) == 1 && is.finite(NatHSS)))
    stop("NatHSS must be a single finite numeric.")
  if (NatHSS < 0 || NatHSS > 1)
    stop("NatHSS must be in [0,1].")
  
  # validate invaders
  if (!is.numeric(InvHSS) || length(InvHSS) < 1 || any(!is.finite(InvHSS)))
    stop("InvHSS must be a finite numeric vector of length >= 1.")
  if (any(InvHSS < 0 | InvHSS > 1))
    stop("All InvHSS values must be in [0,1].")
  
  # validate weights
  if (!is.numeric(alpha) || any(!is.finite(alpha)) || any(alpha < 0))
    stop("alpha must be non-negative numeric")
  if (length(alpha) == 1L) {
    alpha <- rep(alpha, length(InvHSS))
  } else if (length(alpha) != length(InvHSS)) {
    stop("alpha must have length 1 or length equal to length(InvHSS).")
  }
  
  # validate beta
  if (!(is.numeric(beta) && length(beta) == 1 && is.finite(beta) && beta >= 1))
    stop("beta must be a single numeric >= 1.0")
  
  # compute invasive pressure
  omega = sum(alpha * InvHSS)
  
  # negative exponential down-weighting
  return(NatHSS * beta^-omega)
}

# run some examples ------------------------------------------------------------

# 1 invasive species
NatHSS = 1
InvHSS = 1
alpha = 1
beta = 2

RHM(NatHSS,
    InvHSS,
    alpha,
    beta)

# 1 invasive species
NatHSS = 0.5
InvHSS = 1
alpha = 1
beta = 2

RHM(NatHSS,
    InvHSS,
    alpha,
    beta)


# 3 invasive species all with alpha = 1
NatHSS = 1
InvHSS = c(1, 1, 1)
alpha =c(1,1,1)
beta = 2

RHM(NatHSS,
    InvHSS,
    alpha,
    beta)

# 3 invasive species with variable alpha
NatHSS = 1
InvHSS = c(0.3, 0.5, 0.7)
alpha =c(0.5, 1, 2)
beta = 2

RHM(NatHSS,
    InvHSS,
    alpha,
    beta)


# END